const { ipcMain, dialog, app } = require('electron');
const { saveFile, getFile, deleteFile, createFileLink } = require('./file');
const Store = require("electron-store");
const store = new Store();

let winDict = {};

/**
 * 创建主线程事件监听
 */
const createEvents = function (data) {
    const { mainWindow } = data;
    // 打开文件，将文件保存到用户本地
    ipcMain.on('saveFile', (e, params) => saveFile(e, params, data));

    ipcMain.handle('getLocalPdf', (e, params) => getFile(e, params, data));

    ipcMain.on('deleteFile', (e, params) => deleteFile(e, params, data));

    ipcMain.on('createFileLink', (e, params) => createFileLink(e, params, data));

    ipcMain.on('setWindow', (e, id) => setWindow(id));
    ipcMain.on('closedWindow', (e, win) => closedWindow(win));
    ipcMain.handle('getWindowIsMain', (e, id) => getWindowIsMain(id));
    // let rememberMyChoice = store.get('choice.rememberChoice')
    // let localRemberMyChoice = false;
    // mainWindow.on('close', (e) => {
    //     e.preventDefault();
    //     if (rememberMyChoice || localRemberMyChoice) {
    //         let state = store.get('choice')
    //         console.log(state, '11')
    //         if (state.response === 0) {
    //             e.preventDefault();
    //             mainWindow.minimize();
    //         }
    //         if (state.response === 1) {
    //             mainWindow.destroy();
    //             app.exit();
    //         }
    //     } else {
    //         dialog.showMessageBox(mainWindow, {
    //             type: 'info',
    //             buttons: ['最小化', '直接退出'],
    //             title: '提示',
    //             message: '确定要关闭吗？',
    //             defaultId: 0,
    //             cancelId: 0,
    //             checkboxLabel: '记住我的选择',
    //             checkboxChecked: rememberMyChoice
    //         }).then((res) => {
    //             if (res) {
    //                 if (res.checkboxChecked === true) {
    //                     let params = {
    //                         response: res.response,
    //                         rememberChoice: true,
    //                     }
    //                     store.set('choice', params)
    //                     localRemberMyChoice = true;
    //                     if (res.response === 0) {
    //                         e.preventDefault();
    //                         mainWindow.minimize();
    //                     }
    //                     if (res.response === 1) {
    //                         mainWindow.destroy();
    //                         app.exit();
    //                     }
    //                 }
    //                 if (res.checkboxChecked === false) {
    //                     if (res.response === 0) {
    //                         e.preventDefault();
    //                         mainWindow.minimize();
    //                     }
    //                     if (res.response === 1) {
    //                         mainWindow.destroy();
    //                         app.exit();
    //                     }
    //                 }
    //             }

    //         })
    //     }

    // })
}

const setWindow = (winId, isMain) => {
    winId = winId.toString();
    winDict[winId] = {
        isMain: !!isMain
    };
}

const closedWindow = (window) => {
    const winId = window.id.toString();
    winDict[winId] = null;
}

const getWindowIsMain = id => {
    const win = winDict[id.toString()];
    return win && win.isMain;
}

module.exports = {
    createEvents,
    setWindow
}