// This file is required by the index.html file and will
// be executed in the renderer process for that window.
// No Node.js APIs are available in this process because
// `nodeIntegration` is turned off. Use `preload.js` to
// selectively enable features needed in the rendering
// process.
const { ipcRenderer, clipboard, Menu, MenuItem, remote } = require("electron");
const TabGroup = require("./js/lib/Tab.js");

const Gesto = require("gesto");
const $ = require("jquery");

let transWbeview = null; // 加载第三方翻译的webview
let transSourceWebview = null; // 触发第三方翻译的webview
let prevActiveTabId = null;
let transInfo = null;
let fanyiDragInstance = null;
let fanyiKey = "sougou";
const { app, dialog } = require("electron").remote;
const path = require("path");
const fs = require("fs");
const os = require("os");
const chokidar = require("chokidar");
const mime = require("mime");
const { v4: uuidv4 } = require("uuid");
const Store = require("electron-store");
const { initTabDrag } = require("./js/util.js");
const { create } = require("sortablejs");
const store = new Store();
let isOpen;
let selectkey;
let isFreeUpload = null;
let viesible = null;
let isCanGoBack = false; // 是否能后退
let isCanGoNext = false; // 是否能前进
let saveTabs = null;
let otherWebview = null;
let otherInfo = null;
let otherKey = "sg_search";
let otherDragInstance = null;
let filePathList = [];
let isProcessing = false;

window.Storage = store;
const NODE_ENV = "production";
// const NODE_ENV = "dev";
// const NODE_ENV = "test";
const isTest = NODE_ENV != "production";
let environment = isTest ? "https://app.qinyanai.com" : "https://app.qinyanai.com";
let homeUrl = "https://app.qinyanai.com/";
if (NODE_ENV == "dev") {
  homeUrl = "http://localhost:3000";
}
if (NODE_ENV == "test") {
  homeUrl = "https://app.qinyanai.com/";
}
if (NODE_ENV == "production") {
  homeUrl = "https://app.qinyanai.com/";
}
// 检验是否存在记录地址
let downloadDir = store.get("downloadDir_01");
// console.log("检验是否存在记录地址:", downloadDir);
let isHave = fs.existsSync(downloadDir);
if (!downloadDir) {
  if (os.type() == "Windows_NT") {
    setTimeout(() => {
      createDir((res) => {
        try {
          downloadDir = res[0] + "/FIRLibrary";
          if (!fs.existsSync(downloadDir)) {
            fs.mkdirSync(downloadDir);
          }
          store.set("downloadDir_01", downloadDir);
          autoUpload();
        } catch (error) {
          alert(error);
        }
      });
    }, 7000);
  } else {
    try {
      downloadDir = app.getPath("userData").split("Library")[0] + "FIR Library";
      fs.mkdirSync(downloadDir);
      store.set("downloadDir_01", downloadDir);
      autoUpload();
    } catch (error) {
      // alert(error);
    }
  }
} else if (downloadDir && !isHave) {
  if (os.type() == "Windows_NT") {
    console.log("error");
  } else {
    downloadDir = app.getPath("userData").split("Library")[0] + "FIR Library";
    fs.mkdirSync(downloadDir);
    store.set("downloadDir_01", downloadDir);
    autoUpload();
  }
} else {
  autoUpload();
}
const chunkSize = 1024 * 1024 * 4;
const fanyiObj = {
  baidu: "https://fanyi.baidu.com/#en/zh",
  youdao: "https://m.youdao.com/translate",
  sougou: "https://fanyi.sogou.com/text",
  deepl: "https://www.deepl.com/translator",
  //   腾讯翻译 https://fanyi.qq.com/
  // （5）彩云小译 https://fanyi.caiyunapp.com/#/
  // （6）牛津词典  https://www.oxfordlearnersdictionaries.com/
  // （7）剑桥词典 https://dictionary.cambridge.org/
  // tencent: "https://fanyi.baidu.com/#en/zh",
  caiyun: "https://fanyi.caiyunapp.com/#/",
  google: "https://translate.google.com/",
  // oxford: "https://fanyi.sogou.com/text",
  // deepl: "https://www.deepl.com/translator",
  bd_search: "https://www.baidu.com/",
  bing_search: "https://bing.com/",
  gg_search: "https://www.google.com/",
  CNKI: "https://dict.cnki.net/index",
};

const otherUrlObj = {
  sg_search: "https://wap.sogou.com/",
  bd_search: "https://www.baidu.com/",
  bing_search: "https://bing.com/",
  gg_search: "https://www.google.com.hk/",
};

let tabGroup = new TabGroup({
  newTab: {
    title: "New Tab",
  },
});

function getTab() {
  const homeTab = tabGroup.addTab({
    title: "首页",
    src: homeUrl,
    // src: "http://localhost:3000/",
    closable: false,
    isHome: true,
    visible: true,
    active: true,
    webviewAttributes: {
      // 关闭 nodeIntegration，防止第三方 UMD 误走 CJS 导致 require 报错
      nodeIntegration: false,
      webpreferences: "contextIsolation=no",
      // allowpopups: true,
      // useragent:
      //   "Mozilla/5.0 (Macintosh; Intel Mac OS X 14_6) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/126.0.0.0 Safari/537.36",
      preload: path.join(__dirname, 'js/polyfills.js'),
    },
  });

  tabGroup.addTab({
    title: "快捷入口",
    src: "https://www.qinyanai.com/internetSite",
    // src: "http://localhost:3000/internetSite",
    // visible: true,
    // active: true
  });
  addWebviewEvent(homeTab);
  initTabDrag(tabGroup);
}

if (store.get("saveTabs") && store.get("saveTabs").length > 0) {
  document.getElementById("tipLoadingTab").style.display = "block";
  document.getElementById("submitTab").addEventListener("click", () => {
    document.getElementById("tipLoadingTab").style.display = "none";
    getTab();
    let tabsA = store.get("saveTabs") || [];
    tabsA &&
      tabsA.length > 0 &&
      tabsA.map((item) => {
        let webviewAttributes = item.webviewAttributes || {};
        const { target, src } = webviewAttributes;
        const link = item.src || target || src;
        webviewAttributes.target = link;
        const newTab = tabGroup.addTab({
          title: item.title,
          // src: item.src,
          src: "",
          webviewAttributes: item.webviewAttributes,
        });
        addWebviewEvent(newTab);
        newTab.webview.focus();
      });
  });
  document.getElementById("cancelTab").addEventListener("click", () => {
    document.getElementById("tipLoadingTab").style.display = "none";
    getTab();
    store.set("saveTabs", []);
  });
} else {
  document.getElementById("tipLoadingTab").style.display = "none";
  getTab();
}

ipcRenderer.on("tab-added", (event, arg) => {
  const src = arg.src;
  const isFir = src.indexOf("qinyanai.com") > -1 || src.indexOf("localhost") > -1;
  if (isFir) {
    arg.webviewAttributes = {
      nodeIntegration: false,
      webpreferences: "contextIsolation=no",
      // allowpopups: true,
      // useragent:
      //   "Mozilla/5.0 (Macintosh; Intel Mac OS X 14_6) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/126.0.0.0 Safari/537.36",
      preload: path.join(__dirname, 'js/polyfills.js'),
    };
  }
  const tab = tabGroup.addTab(arg);
  const tabsList = tabGroup.getTabs();
  saveTabs = [];
  tabsList.map((item) => {
    let { src, target } = item.webviewAttributes;
    if (!item.webview.src) {
      if (!src && !!target) {
        src = target;
      }
    }

    saveTabs.push({
      title: item.title,
      src: src,
      webviewAttributes: item.webviewAttributes,
    });
  });
  saveTabs = saveTabs.filter((item) => {
    return (
      item.src !== "https://www.qinyanai.com/internetSite" &&
      item.src !== "https://app.qinyanai.com/" &&
      item.src !== "https://app.qinyanai.com/" &&
      item.src !== "http://localhost:3000" &&
      item.src.indexOf("linkinghub.elsevier.com/retrieve/pii/") == -1 &&
      item.src.indexOf("app.qinyanai.com/canvas") == -1 &&
      item.src.indexOf("app.qinyanai.com/xminds") == -1 &&
      item.src.indexOf("localhost:3000/resource") == -1 &&
      item.src.indexOf("https://app.qinyanai.com/resource") == -1 &&
      item.src.indexOf("https://app.qinyanai.com/resource") == -1
    );
  });
  store.set("saveTabs", saveTabs.reverse() || []);
  addWebviewEvent(tab);
  initTabDrag(tabGroup);
});
ipcRenderer.send("checkForUpdate");
ipcRenderer.on("message", (event, text, arg) => {
  if (text == "检测到新版本，正在下载" && process.platform == "darwin") {
    document.getElementById("dialog").style.display = "block";
    // document.getElementById("upload").style.display = "block";
    document.getElementById("goWeb").style.display = "block";
    document.getElementById("windows").style.display = "none";
    document.getElementById("confirm").style.display = "block";
  }
  if (text == "检测到新版本，正在下载" && process.platform == "win32") {
    document.getElementById("dialog").style.display = "block";
    document.getElementById("goWeb").style.display = "none";
    document.getElementById("windows").style.display = "block";
    document.getElementById("upload").style.display = "block";
  }
});

// 全局热键触发翻译：从剪贴板读取或尝试当前 webview 选中
ipcRenderer.on('hotkey-translate-selection', async () => {
  try {
    const activeTab = tabGroup.getActiveTab();
    const vw = activeTab && activeTab.webview;
    let text = '';
    try {
      // 优先尝试从 webview 读取 window.getSelection（若可达）
      text = await vw.executeJavaScript(`(function(){
        try {
          var sel = (window.getSelection && window.getSelection()) || null;
          var t = sel ? String(sel.toString()||'').trim() : '';
          if (!t && document && document.activeElement && document.activeElement.tagName==='IFRAME'){
            var d = document.activeElement.contentWindow || document.activeElement.contentDocument;
            if(d){
              var s2 = (d.getSelection && d.getSelection()) || null;
              t = s2 ? String(s2.toString()||'').trim() : '';
            }
          }
          return t;
        } catch(e){ return ''; }
      })()`);
    } catch (_) { }

    if (!text) {
      // 回退到剪贴板
      try { text = clipboard.readText() || ''; } catch (_) { }
    }
    if (!text) return;

    $(".trans-box")
      .css({ transform: `translate(0px, 0px) scale(1)` })
      .show();
    initFanyiDrag();
    transInfo = { content: text, params: {} };
    transSourceWebview = vw;
    if (transWbeview && fanyiKey.indexOf('_search') == -1) {
      transWbeview.send("translate", transInfo);
    } else {
      initTransWebview(fanyiKey, true);
    }
  } catch (e) { console.error('[HOTKEY translate] error', e); }
});

document.getElementById("back").src = "./images/backDefault.svg";
document.getElementById("forward").src = "./images/forwardDefault.svg";

document.getElementById("confirm").addEventListener("click", () => {
  document.getElementById("dialog").style.display = "none";
  document.getElementById("confirm").style.display = "none";
});

document.getElementById("upload").addEventListener("click", () => {
  document.getElementById("dialog").style.display = "none";
  ipcRenderer.send("manualUpdate");
});
ipcRenderer.on("downloadProgress", (event, progressObj) => {
  // 下载进度（如需调试可临时打印）
});

ipcRenderer.on("isUpdateNow", () => {
  ipcRenderer.send("isUpdateNow");
});
window.onunload = function () {
  ipcRenderer.removeAll(["message", "downloadProgress", "isUpdateNow"]);
};
window.onload = function () {
  setFanyiKey();
  setOtherKey();
};

document.getElementById("backImg").addEventListener("click", () => {
  ipcRenderer.send("goBack");
});

document.getElementById("initSynchronous").addEventListener("click", () => {


  let formData = new FormData();
  let webUrl = tabGroup.tabs[0].webview.src;
  let title =
    tabGroup.tabs[0].title.length > 200
      ? tabGroup.tabs[0].title.substring(0, 120) + '.pdf'
      : tabGroup.tabs[0].title + '.pdf';
  let info = JSON.stringify({
    name: title.replace('Sci-Hub | ', ''),
    task_id: new Date().getTime(),
  });
  if (tabGroup.tabs[0].webviewAttributes.src.includes("sci-hub") || (tabGroup.tabs[0].webviewAttributes.target && tabGroup.tabs[0].webviewAttributes.target.includes("sci-hub"))) {
    document.getElementById("requestBu").style.display = "block";
    document.getElementById("requestImg").src = "./images/loding.svg";
    document.getElementById("requestText").innerHTML = "正在收录";
    document.getElementById("initSynchronous").disabled = true;
    var obj = document.getElementById("progressBar");
    var num = obj.innerText;
    var sleep = setInterval(function () {
      num++;
      obj.innerText = num + "%";
      if (num == 100) {
        clearInterval(sleep);
      }
    }, 100);
    formData.append("file_info", info);
    formData.append("file_link", webUrl);
    webPostPromise(obj, formData, sleep);
  } else {
    let reg =
      /^([hH][tT]{2}[pP]:\/\/|[hH][tT]{2}[pP][sS]:\/\/)(([A-Za-z0-9-~]+).)+([A-Za-z0-9-~\/])+$/;
    if (!reg.test(webUrl)) {
      throw new Error("传入参数不合法,不是标准的文件链接");
    } else {
      let xhr = new XMLHttpRequest();
      xhr.open("get", webUrl, true);
      xhr.setRequestHeader("Content-Type", "application/pdf");
      xhr.responseType = "blob";
      xhr.onload = async function () {
        if (this.status == 200) {
          if (this.response.type == 'text/html') {
            copyBox("该文件不支持收录", 5000, ".etabs-views");
            return;
          }
          document.getElementById("requestBu").style.display = "block";
          document.getElementById("requestImg").src = "./images/loding.svg";
          document.getElementById("requestText").innerHTML = "正在收录";
          document.getElementById("initSynchronous").disabled = true;
          var obj = document.getElementById("progressBar");
          var num = obj.innerText;
          var sleep = setInterval(function () {
            num++;
            obj.innerText = num + "%";
            if (num == 100) {
              clearInterval(sleep);
            }
          }, 100);
          //接受二进制文件流
          formData.append("file_info", info);
          // formData.append("file", this.response);
          if (
            (isFreeUpload == "1001" || store.get("isFreeUpload") == "1001") &&
            (this.response.size / 1024 / 1024).toFixed(2) > 20
          ) {
            copyBox("免费用户单个文件上传不超过20M", 10000, ".etabs-views");
            return;
          }
          if ((this.response.size / 1024 / 1024).toFixed(2) > 200) {
            copyBox("文件上传容量不超过200MB", 10000, ".etabs-views");
            return;
          }
          postPromise(title, this.response, obj, sleep)
        }
      };
      xhr.send();
    }
  }
});

async function postPromise(title, file, obj, sleep) {
  const chunkSize = 1024 * 1024 * 4;
  if (file.size > chunkSize) {
    ucloudBigHander(title, file, chunkSize, obj, sleep)
  } else {
    ucloudSmallHander(title, file, obj, sleep)
  }
}
function webPostPromise(obj, formData, sleep) {
  Promise.race([
    fetch(`${environment}/api/resource/upload/whole/`, {
      method: "POST",
      headers: {
        "app-Session-Id": globalThis.__token__,
      },
      body: formData,
    })
      .then((res) => {
        return res.json();
      })
      .then((res) => {
        if (res && res.code == 1) {
          if (
            tabGroup.tabs.map((item) => {
              if (item.id == 0) {
                item.webview.reload();
              }
            })
          )
            document.getElementById("initSynchronous").style.background =
              "#C4C4C4";
          document.getElementById("initSynchronous").disabled = true;
          num = 100;
          obj.innerText = 100 + "%";
          clearInterval(sleep);
          document.getElementById("requestImg").src = "./images/success.svg";
          document.getElementById("requestImg").style.marginTop = "8px";
          document.getElementById("requestText").innerHTML = "收录成功";
          document.getElementById("requestText").style.marginTop = "75px";
          document.getElementById("progressBar").innerText = "";
          setTimeout(() => {
            document.getElementById("requestBu").style.display = "none";
          }, 1000);
        } else {
          num = 99;
          obj.innerText = 99 + "%";
          clearInterval(sleep);
          document.getElementById("requestImg").src = "./images/error.svg";
          document.getElementById("requestImg").style.marginTop = "8px";
          document.getElementById("requestText").innerHTML = res.msg;
          document.getElementById("requestText").style.marginTop = "75px";
          document.getElementById("progressBar").innerText = "";
          setTimeout(() => {
            document.getElementById("requestBu").style.display = "none";
          }, 1000);
        }
      }),
    new Promise((resovle, reject) => {
      setTimeout(() => {
        reject(new Error("请求超时"));
        document.getElementById("requestText").innerHTML = "请求超时";
        document.getElementById("progressBar").innerText = "";
        document.getElementById("initSynchronous").disabled = false;

        setTimeout(() => {
          document.getElementById("requestBu").style.display = "none";
          document.getElementById("progressBar").innerText = "";
        }, 3000);
      }, 15000);
    }),
  ]);
}

async function ucloudBigHander(title, file, chunkSize, obj, sleep) {
  try {
    let fileMd5 = uuidv4();
    let chunks = Math.ceil(file.size / chunkSize);
    const formData1 = new FormData();
    formData1.append("multipart", 1);
    const resp = await fetch(
      `${environment}/api/res/upload_token/`,
      {
        method: "POST",
        headers: {
          "app-Session-Id": globalThis.__token__,
        },
        body: formData1,
      }
    );
    const res = await resp.json();
    if (res.code == 1) {
      const {
        file_key,
        post_header,
        post_url,
        put_header,
        put_url,
      } = res.data;
      const etagList = [];
      for (let i = 0; i < chunks; i++) {
        let end =
          (i + 1) * chunkSize >= file.size
            ? file.size
            : (i + 1) * chunkSize;
        const response = await fetch(`${put_url}${i}`, {
          method: "PUT",
          headers: put_header,
          body: file.slice(i * chunkSize, end),
        });
        const headers = response.headers;
        // 遍历响应头
        headers.forEach((value, name) => {
          if (name == "etag") {
            etagList.push(value);
          }
        });
        if (end == file.size && response.status == 200) {
          const controller = new AbortController();
          const signal = controller.signal;
          // const timeoutId = setTimeout(() => {
          //   controller.abort();
          // }, 60000); // 设置请求超时时间为60秒
          const result = etagList.map((item) =>
            item.replace(/\\/g, "")
          );
          const output = result.join(",");
          const formp = new FormData();
          formp.append("data", output);
          const rep = await fetch(post_url, {
            method: "POST",
            headers: post_header,
            body: formp,
          });
          if (rep.status == 200) {
            let winSelectedKey = store.get("windowSelectedKey");
            const repData = new FormData();
            repData.append("file_key", file_key);
            repData.append(
              "file_info",
              JSON.stringify({
                name: title,
                task_id: fileMd5,
              })
            );
            // let winOpen = store.get("windowIsOpen");
            // if (isOpen || winOpen) {
            //   repData.append(
            //     "pid",
            //     winSelectedKey == "" || winSelectedKey == undefined
            //       ? ""
            //       : winSelectedKey || selectkey
            //   );
            // }

            const Data = await fetch(
              `${environment}/api/res/upload_success/`,
              {
                method: "POST",
                headers: {
                  "app-Session-Id": globalThis.__token__,
                },
                body: repData,
                // signal,
              }
            );
            const callData = await Data.json();
            if (callData.code == 1) {
              // clearTimeout(timeoutId);
              if (
                tabGroup.tabs.map((item) => {
                  if (item.id == 0) {
                    item.webview.reload();
                  }
                })
              )
                document.getElementById("initSynchronous").style.background =
                  "#C4C4C4";
              document.getElementById("initSynchronous").disabled = true;
              num = 100;
              obj.innerText = 100 + "%";
              clearInterval(sleep);
              document.getElementById("requestImg").src = "./images/success.svg";
              document.getElementById("requestImg").style.marginTop = "8px";
              document.getElementById("requestText").innerHTML = "收录成功";
              document.getElementById("requestText").style.marginTop = "75px";
              document.getElementById("progressBar").innerText = "";
              setTimeout(() => {
                document.getElementById("requestBu").style.display = "none";
              }, 1000);
            } else if (callData.code == 20108) {
              clearInterval(sleep);
              document.getElementById("requestImg").src = "./images/error.svg";
              document.getElementById("requestImg").style.marginTop = "8px";
              document.getElementById("requestText").innerHTML = "存储空间已达上限";
              document.getElementById("requestText").style.marginTop = "75px";
              document.getElementById("progressBar").innerText = "";
              setTimeout(() => {
                document.getElementById("requestBu").style.display = "none";
              }, 1000);
            } else if (callData.code == 20107) {
              clearInterval(sleep);
              document.getElementById("requestImg").src = "./images/error.svg";
              document.getElementById("requestImg").style.marginTop = "8px";
              document.getElementById("requestText").innerHTML = "上级分类获取失败";
              document.getElementById("requestText").style.marginTop = "75px";
              document.getElementById("progressBar").innerText = "";
              setTimeout(() => {
                document.getElementById("requestBu").style.display = "none";
              }, 1000);
            } else {
              num = 99;
              obj.innerText = 99 + "%";
              clearInterval(sleep);
              document.getElementById("requestImg").src = "./images/error.svg";
              document.getElementById("requestImg").style.marginTop = "8px";
              document.getElementById("requestText").innerHTML = res.msg;
              document.getElementById("requestText").style.marginTop = "75px";
              document.getElementById("progressBar").innerText = "";
              setTimeout(() => {
                document.getElementById("requestBu").style.display = "none";
              }, 1000);
            }
          }
        }
      }
    } else {
      clearInterval(sleep);
      document.getElementById("requestImg").src = "./images/success.svg";
      document.getElementById("requestImg").style.marginTop = "8px";
      document.getElementById("requestText").innerHTML = res.msg == 'no login' ? '未登录' : res.msg;
      document.getElementById("requestText").style.marginTop = "75px";
      document.getElementById("progressBar").innerText = "";
      setTimeout(() => {
        document.getElementById("requestBu").style.display = "none";
      }, 1000);
    }
  } catch (err) {
    setTimeout(() => {
      document.getElementById("requestText").innerHTML = "请求超时";
      document.getElementById("progressBar").innerText = "";
      document.getElementById("initSynchronous").disabled = false;

      setTimeout(() => {
        document.getElementById("requestBu").style.display = "none";
        document.getElementById("progressBar").innerText = "";
      }, 3000);
    }, 15000);
  }
}

async function ucloudSmallHander(title, file, obj, sleep) {
  try {
    const formData = new FormData();
    formData.append("multipart", 0);
    const response = await fetch(
      `${environment}/api/res/upload_token/`,
      {
        method: "POST",
        headers: {
          "app-Session-Id": globalThis.__token__,
        },
        body: formData,
      }
    );
    const res = await response.json();
    if (res.code == 1) {
      const { file_key, put_header, put_url } = res.data;
      const resData = await fetch(put_url, {
        method: "PUT",
        headers: put_header,
        body: file,
      });
      if (resData.status == 200) {
        let winSelectedKey = store.get("windowSelectedKey");
        const postData = new FormData();
        postData.append("file_key", file_key);
        postData.append(
          "file_info",
          JSON.stringify({
            name: title,
            task_id: uuidv4(),
          })
        );
        // let winOpen = store.get("windowIsOpen");
        // if (isOpen || winOpen) {
        //   postData.append(
        //     "pid",
        //     winSelectedKey == "" || winSelectedKey == undefined
        //       ? ""
        //       : winSelectedKey || selectkey
        //   );
        // }

        const Data = await fetch(
          `${environment}/api/res/upload_success/`,
          {
            method: "POST",
            headers: {
              "app-Session-Id": globalThis.__token__,
            },
            body: postData,
          }
        );
        const resp = await Data.json();
        if (resp.code == 1) {
          // clearTimeout(timeoutId);
          if (
            tabGroup.tabs.map((item) => {
              if (item.id == 0) {
                item.webview.reload();
              }
            })
          )
            document.getElementById("initSynchronous").style.background =
              "#C4C4C4";
          document.getElementById("initSynchronous").disabled = true;
          num = 100;
          obj.innerText = 100 + "%";
          clearInterval(sleep);
          document.getElementById("requestImg").src = "./images/success.svg";
          document.getElementById("requestImg").style.marginTop = "8px";
          document.getElementById("requestText").innerHTML = "收录成功";
          document.getElementById("requestText").style.marginTop = "75px";
          document.getElementById("progressBar").innerText = "";
          setTimeout(() => {
            document.getElementById("requestBu").style.display = "none";
          }, 1000);
        } else if (resp.code == 20108) {
          clearInterval(sleep);
          document.getElementById("requestImg").src = "./images/error.svg";
          document.getElementById("requestImg").style.marginTop = "8px";
          document.getElementById("requestText").innerHTML = "存储空间已达上限";
          document.getElementById("requestText").style.marginTop = "75px";
          document.getElementById("progressBar").innerText = "";
          setTimeout(() => {
            document.getElementById("requestBu").style.display = "none";
          }, 1000);
        } else if (resp.code == 20107) {
          clearInterval(sleep);
          document.getElementById("requestImg").src = "./images/error.svg";
          document.getElementById("requestImg").style.marginTop = "8px";
          document.getElementById("requestText").innerHTML = "上级分类获取失败";
          document.getElementById("requestText").style.marginTop = "75px";
          document.getElementById("progressBar").innerText = "";
          setTimeout(() => {
            document.getElementById("requestBu").style.display = "none";
          }, 1000);
        } else {
          num = 99;
          obj.innerText = 99 + "%";
          clearInterval(sleep);
          document.getElementById("requestImg").src = "./images/error.svg";
          document.getElementById("requestImg").style.marginTop = "8px";
          document.getElementById("requestText").innerHTML = res.msg;
          document.getElementById("requestText").style.marginTop = "75px";
          document.getElementById("progressBar").innerText = "";
          setTimeout(() => {
            document.getElementById("requestBu").style.display = "none";
          }, 1000);
        }
      }
    } else {
      clearInterval(sleep);
      document.getElementById("requestImg").src = "./images/success.svg";
      document.getElementById("requestImg").style.marginTop = "8px";
      document.getElementById("requestText").innerHTML = res.msg == 'no login' ? '未登录' : res.msg;
      document.getElementById("requestText").style.marginTop = "75px";
      document.getElementById("progressBar").innerText = "";
      setTimeout(() => {
        document.getElementById("requestBu").style.display = "none";
      }, 1000);
    }
  } catch (err) {
    console.log(err)
  }
}


document.getElementById("right").addEventListener("click", () => {
  var ul = document.getElementById("list");
  while (ul.hasChildNodes()) {
    //当div下还存在子节点时 循环继续
    ul.removeChild(ul.firstChild);
  }
});

document.getElementById("refresh").addEventListener("click", () => {
  ipcRenderer.send("changeConnect", false);
  // ipcRenderer.sendToHost("changeConnect", connectTransInput.checked)
  tabGroup.tabs[0].webview.reload();
  closeTranslatemodal();
  closeOthermodal();
  // transWbeview && transWbeview.reload && transWbeview.reload();
});
document.getElementById("copyImg").addEventListener("click", () => {
  let url =
    tabGroup.tabs[0].webviewAttributes.src ||
    tabGroup.tabs[0].webviewAttributes.target;
  clipboard.writeText(url);
  copyBox("网页链接复制成功~", 2500, ".etabs-views");
});
// document.getElementById("uploadDiv").style.display = "none";
document.getElementById("headerRight").addEventListener("click", () => {
  document.getElementById("uploadDiv").style.display = "none";
  viesible = false;
  // document.getElementById("openUpload").style.display = "block";
  // document.getElementById("deleteImg").style.display = "block";
});

if (tabGroup) {
  tabGroup.tabs.map((item) => {
    if (item.webviewAttributes.src.includes("qinyanai.com")) {
      // document.getElementById("initWebPhoto").style.display = "none";
      document.getElementById("initSynchronous").style.display = "none";
    }
  });
}
tabGroup.on("tab-active", function (e) {
  if (e) {
    // document.getElementById("initWebPhoto").style.background = "#55C0FF";
    // document.getElementById("initWebPhoto").disabled = false;
    if (e.webviewAttributes.src.includes('qinyanai.com')) {
      document.getElementById("initSynchronous").style.display = "none";
    }
    document.getElementById("initSynchronous").style.background = "#55C0FF";
    document.getElementById("initSynchronous").disabled = false;

    if (!e.webviewAttributes.src.includes("https://app.qinyanai.com")) {
      document.getElementById("uploadDiv").style.display = "none";
    } else if (
      e.webviewAttributes.src.includes("https://app.qinyanai.com") &&
      (document.getElementById("uploadDiv").style.display == "block" ||
        viesible)
    ) {
      document.getElementById("uploadDiv").style.display = "block";
    }
    // if (e.webviewAttributes.src !== "https://app.qinyanai.com") {
    //   document.getElementById("uploadDiv").style.display = "none";
    // } else if (
    //   e.webviewAttributes.src == "https://app.qinyanai.com" &&
    //   (document.getElementById("uploadDiv").style.display == "block" ||
    //     viesible)
    // ) {
    //   document.getElementById("uploadDiv").style.display = "block";
    //   document.getElementById("deleteImg").style.display = "none";
    // }
    // if (e.webviewAttributes.src !== "https://app.qinyanai.com") {
    //   document.getElementById("deleteImg").style.display = "none";
    // } else if (
    //   e.webviewAttributes.src == "https://app.qinyanai.com" &&
    //   ((document.getElementById("openUpload").style.display == "block" &&
    //     document.getElementById("deleteImg").style.display == "block") ||
    //     viesible)
    // ) {
    //   document.getElementById("openUpload").style.display = "block";
    //   document.getElementById("deleteImg").style.display = "block";
    //   document.getElementById("uploadDiv").style.display = "none";
    // }
    if (!e.webviewAttributes.src.includes("pdf")) {
      document.getElementById("initSynchronous").style.display = "none";
    } else {
      document.getElementById("initSynchronous").style.display = "block";
    }
    // if (e.webviewAttributes.src.includes("qinyanai.com")) {
    //   document.getElementById("initWebPhoto").style.display = "none";
    // } else {
    //   document.getElementById("initWebPhoto").style.display = "block";
    // }
    // if (e.webviewAttributes.src.includes("pdf")) {
    //   document.getElementById("initWebPhoto").style.display = "none";
    // }
    if (e.webviewAttributes.src.includes("sci-hub")) {
      // document.getElementById("initWebPhoto").style.display = "none";
      document.getElementById("initSynchronous").style.display = "block";
    }
    if (
      e.webviewAttributes.src.includes("sci-hub") &&
      e.webviewAttributes.src.length < 24
    ) {
      // document.getElementById("initWebPhoto").style.display = "block";
      document.getElementById("initSynchronous").style.display = "none";
    }
    if (
      e.webviewAttributes.src.includes("sci-hub") &&
      e.webview.outerHTML.length > 66
    ) {
      // document.getElementById("initWebPhoto").style.display = "none";
      document.getElementById("initSynchronous").style.display = "block";
    }
    if (e.webviewAttributes.src.includes("reader")) {
      document.getElementById("initSynchronous").style.display = "none";
      // document.getElementById("initWebPhoto").style.display = "block";
    }
    if (
      e.webview.outerHTML.includes(".pdf") &&
      e.webview.outerHTML.includes("ncbi")
    ) {
      document.getElementById("initSynchronous").style.display = "block";
      // document.getElementById("initWebPhoto").style.display = "none";
    }

    if (e.webview.outerHTML.includes(".pdf")) {
      document.getElementById("initSynchronous").style.display = "block";
      // document.getElementById("initWebPhoto").style.display = "none";
    }
    e.webview.addEventListener("did-start-navigation", async (res) => {
      if (res.url.includes('qinyanai.com')) {
        document.getElementById("initSynchronous").style.display = "none";
        return;
      }
      if (res.url.includes(".pdf") || res.target.outerHTML.includes(".pdf")) {
        // document.getElementById("initWebPhoto").style.display = "none";
        document.getElementById("initSynchronous").style.display = "block";
      }
      if (res.url.includes(".pdf&")) {
        // document.getElementById("initWebPhoto").style.display = "block";
        document.getElementById("initSynchronous").style.display = "none";
      }
      if (e.webview && e.webview.canGoBack()) {
        isCanGoBack = true;
        document.getElementById("back").src = "./images/back.svg";
      } else {
        isCanGoBack = false;
        document.getElementById("back").src = "./images/backDefault.svg";
      }
      if (e.webview && e.webview.canGoForward()) {
        isCanGoNext = true;
        document.getElementById("forward").src = "./images/forward.svg";
      } else {
        isCanGoNext = false;
        document.getElementById("forward").src = "./images/forwardDefault.svg";
      }
    });
    // console.log(e.tabGroup.tabs[0].webview.outerHTML)

    const activeTab = tabGroup.getActiveTab();
    const curActiveTabId = activeTab && activeTab.id;
    if (curActiveTabId !== prevActiveTabId) {
      closeTranslatemodal();
      closeOthermodal();
    }
    prevActiveTabId = curActiveTabId;

    setTimeout(() => {
      if (e.webview && e.webview.canGoBack()) {
        isCanGoBack = true;
        document.getElementById("back").src = "./images/back.svg";
      } else {
        isCanGoBack = false;
        document.getElementById("back").src = "./images/backDefault.svg";
      }
      if (e.webview && e.webview.canGoForward()) {
        isCanGoNext = true;
        document.getElementById("forward").src = "./images/forward.svg";
      } else {
        isCanGoNext = false;
        document.getElementById("forward").src = "./images/forwardDefault.svg";
      }
    }, 10);
  }
});

ipcRenderer.on("can-goback", (event, arg) => {
  if (arg) {
    isCanGoBack = arg;
    document.getElementById("back").src = "./images/back.svg";
  } else {
    isCanGoBack = arg;
    document.getElementById("back").src = "./images/backDefault.svg";
  }
});

ipcRenderer.on("can-goforward", (event, arg) => {
  if (arg) {
    isCanGoNext = arg;
    document.getElementById("forward").src = "./images/forward.svg";
  } else {
    isCanGoNext = arg;
    document.getElementById("forward").src = "./images/forwardDefault.svg";
  }
});

// 点击前进后退
document.getElementById("back").addEventListener("click", (e) => {
  const activeTab = tabGroup.getActiveTab();
  const curActiveTabId = activeTab.id;
  tabGroup.tabs.map((item) => {
    if (item.id == curActiveTabId) {
      if (isCanGoBack) tabGroup.tabs[0].webview.goBack();
    }
  });
});

document.getElementById("forward").addEventListener("click", (e) => {
  const activeTab = tabGroup.getActiveTab();
  const curActiveTabId = activeTab && activeTab.id;
  tabGroup.tabs.map((item) => {
    if (item.id == curActiveTabId) {
      if (isCanGoNext) tabGroup.tabs[0].webview.goForward();
    }
  });
});

// 初始化翻译webview
function initTransWebview(key, first) {
  const transWarp = document.getElementById("trans-warp");
  $("#transWeb").remove();

  transWbeview = null;
  transWbeview = document.createElement("webview");


  let url = fanyiObj[key];
  const isSearch = key.indexOf("_search") > -1;
  let isInit = false;
  $("#translateSrc").val(key);
  let dragWidth = 57.5;
  if (key === "deepl" || key === 'caiyun') {
    transWarp.style.width = "650px";
    dragWidth = 195;
    $("#trans-warp").height(530);
  } else {
    transWarp.style.width = "375px";
    if (key === "youdao") {
      $("#trans-warp").height(520);
    }
    if (key === "sougou") {
      $("#trans-warp").height(520);
    }
  }
  $(".drag-tag-lr").width(dragWidth);

  if (isSearch) {
    //   bd_search: "https://www.baidu.com/",
    // bing_search: "https://bing.com/",
    // gg_search: "https://www.google.com/",
    const keywords = transInfo.content;
    if (key == "gg_search") {
      url += `search?q=${keywords}`;
    }
    if (key == "bing_search") {
      url += `search?q=${keywords}`;
    }
    if (key == "bd_search") {
      url += `s?word=${keywords}`;
    }
  }

  if (key == "deepl") {
    url += `#en/zh/${transInfo.content}`;
  }

  transWbeview.setAttribute("src", url);
  if (!isSearch) {
    transWbeview.setAttribute("preload", "./js/fanyi/wrap.js");
  }
  // 显式为翻译 webview 开启 Node 能力，保障 wrap.js 可用
  try {
    transWbeview.setAttribute("nodeintegration", "true");
    transWbeview.setAttribute("webpreferences", "contextIsolation=no");
  } catch (e) { }

  transWbeview.setAttribute("id", "transWeb");
  transWbeview.setAttribute("fanyikey", key);
  transWbeview.setAttribute("style", "visibility: visible;");
  transWbeview.setAttribute(
    "useragent",
    "Mozilla/5.0 (iPhone; CPU iPhone OS 13_2_3 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.3 Mobile/15E148 Safari/604.1"
  );

  transWarp.appendChild(transWbeview);

  transWbeview.addEventListener("dom-ready", () => {
    if (isSearch) return;
    transWbeview.send("initTranslateSource", key);

    if ((!first && !isInit) || first) {
      transWbeview.send("translate", transInfo);
      isInit = true;
      first = false;
    }
  });

  transWbeview.addEventListener("ipc-message", (event) => {
    if (event.channel === "translateRes") {
      // transSourceWebview.openDevTools()
      transSourceWebview.send("clientTranslateRes", event.args[0]);
    }

    if (event.channel === "copyTranslateRes") {
      clipboard.writeText(event.args[0]);
      showTips("译文复制成功~", 2500, "#trans-warp");
    }

    if (event.channel === "closeTranslateRes") {
      closeTranslatemodal();
    }

    if (event.channel === "print") {
      showTips("译文复制成功~", 2500, "#trans-warp");
    }

    if (event.channel === "changeConnect") {
      transSourceWebview.send("changeConnect", event.args[0]);
    }
  });


}

//初始化搜索webview
function initOtherWebview(key, first) {
  const otherWarp = document.getElementById("otherUrl-warp");
  $("#otherWeb").remove();
  otherWebview = null;
  otherWebview = document.createElement("webview");
  let url = otherUrlObj[key];
  $("#otherUrl").val(key);
  let dragWidth = 57.5;
  $(".drag-tag-lr1").width(dragWidth);
  const keywords = otherInfo.content;
  let isInit = false;
  if (keywords !== null) {
    if (key == "sg_search") {
      url += `web/searchList.jsp?keyword=${keywords}`;
    }
    if (key == "gg_search") {
      url += `search?q=${keywords}`;
    }
    if (key == "bing_search") {
      url += `search?q=${keywords}`;
    }
    if (key == "bd_search") {
      url += `s?word=${keywords}`;
    }
  }
  otherWebview.setAttribute("src", url);
  otherWebview.setAttribute("id", "otherWeb");
  otherWebview.setAttribute("otherKey", key);
  otherWebview.setAttribute("style", "visibility: visible;");
  // 搜索 webview 不需要 Node，保持禁用，避免污染第三方站点
  otherWebview.setAttribute(
    "useragent",
    "Mozilla/5.0 (iPhone; CPU iPhone OS 13_2_3 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.3 Mobile/15E148 Safari/604.1"
  );
  otherWarp.appendChild(otherWebview);
  otherWebview.addEventListener("dom-ready", () => {
    otherWebview.send("initOtherSource", key);
    if ((!first && !isInit) || first) {
      otherWebview.send("otherKey", otherInfo);
      isInit = true;
      first = false;
    }
  });
}

function showTips(text, time = 2500, selector = "body") {
  $(".tips-box").appendTo($(selector));
  $(".tips-box").text(text).show();
  const timer = setTimeout(() => {
    $(".tips-box").hide();
    clearTimeout(timer);
  }, time);
}

function copyBox(text, time = 2500, selector = "body") {
  $(".copy-box").appendTo($(selector));
  $(".copy-box").text(text).show();
  const timer = setTimeout(() => {
    $(".copy-box").hide();
    clearTimeout(timer);
  }, time);
}

function ipcMessage(webview, event) {

  if (event.channel === "clientTranslate") {
    let info = event.args[0];
    $(".trans-box")
      .css({
        transform: `translate(0px, 0px) scale(1)`,
      })
      .show();
    initFanyiDrag();

    transInfo = info;
    transSourceWebview = webview;

    if (transWbeview && fanyiKey.indexOf('_search') == -1) {
      transWbeview.send("translate", transInfo);
    } else {
      initTransWebview(fanyiKey, true);
    }
    transSourceWebview.addEventListener("load-commit", (args) => {
      try {
        const url = transSourceWebview.getURL();
        const isFilePreview = url.indexOf("/files/") > -1;
        if (!isFilePreview) {
          closeTranslatemodal();
        }
      } catch (error) {
        console.log(error);
      }
    });
  }
  if (event.channel === "clientTranslateClose") {
    closeTranslatemodal();
  }

  if (event.channel === "clientOtherWrap") {
    let info = event.args[0];
    $(".otherUrl-box")
      .css({
        transform: `translate(0px, 0px) scale(1)`,
      })
      .show();
    initOtherDrag();
    otherInfo = {
      content: info,
    };
    initOtherWebview(otherKey, "first");
    // otherWebview.addEventListener("load-commit", (args) => {
    //   try {
    //     const isFilePreview = url.indexOf("/files/") > -1;
    //     if (!isFilePreview) {
    //       closeTranslatemodal();
    //     }
    //   } catch (error) {
    //     console.log(error);
    //   }
    // });
  }
  if (event.channel === "clientOtherSearch") {
    let info = event.args[0];
    otherInfo = {
      content: info,
    };
    if (otherWebview) {
      initOtherWebview(otherKey);
    }
  }
}

window.addEventListener("contextmenu", function (e) {
  e.preventDefault();
});

function addWebviewEvent(tab) {
  const webview = tab.webview;
  webview.addEventListener("dom-ready", () => {
    webview.addEventListener("ipc-message", (event) => {
      ipcMessage(webview, event);
      if (event.channel == "isOpen") {
        let info = event.args[0];
        isOpen = info;
        store.set("windowIsOpen", info);
        filePathList = [];
        isProcessing = false;
      }
      if (event.channel == "selectedKey") {
        let info = event.args[0];
        selectkey = info;
        store.set("windowSelectedKey", info);
      }
      if (event.channel == "isVisible" && event.args[0] == true) {
        document.getElementById("uploadDiv").style.display = "none";
      }
      if (event.channel == "peopleMenuCode" && event.args[0]) {
        isFreeUpload = event.args[0];
        store.set("isFreeUpload", event.args[0]);
      }
      if (event.channel == "lookList") {
        let info = event.args[0];
        if (info) {
          document.getElementById("uploadDiv").style.display = "block";
          viesible = true;
        }
      }
    });

    webview.addEventListener(
      "context-menu",
      (event) => {
        event.preventDefault();
        event.stopPropagation();
        let params = event && event.params;
        let menu = createMenu(params, webview);
        if (params) {
          if (process.platform === "win32") {
            setTimeout(() => {
              if (menu) {
                menu.popup(remote.getCurrentWindow());
              }
            }, 500);
          } else {
            if (menu) {
              menu.popup(remote.getCurrentWindow());
            }
          }
        }
      },
      false
    );
  });
}

function createMenu(options, webview) {
  const hasText = options.selectionText.trim().length > 0;
  const can = (type) => options.editFlags[`can${type}`] && hasText;
  let menu = new remote.Menu();
  // 添加复制菜单项
  menu.append(
    new remote.MenuItem({
      label: "复制",
      accelerator: "CmdOrCtrl+C",
      click: () => {
        clipboard.writeText(options.selectionText, "selection");
      },
      enabled: can("Copy"),
    })
  );

  // 翻译选中文本
  try {
    menu.append(
      new remote.MenuItem({
        label: "翻译选中文本",
        accelerator: "CmdOrCtrl+Shift+T",
        enabled: hasText,
        click: () => {
          try {
            const text = options.selectionText.trim();
            if (!text) return;
            // 复用现有逻辑，等同于收到 clientTranslate 事件
            $(".trans-box")
              .css({
                transform: `translate(0px, 0px) scale(1)`,
              })
              .show();
            initFanyiDrag();
            transInfo = { content: text, params: {} };
            transSourceWebview = webview;
            if (transWbeview && fanyiKey.indexOf('_search') == -1) {
              transWbeview.send("translate", transInfo);
            } else {
              initTransWebview(fanyiKey, true);
            }
          } catch (e) { console.error('[MENU translate] error', e); }
        },
      })
    );
  } catch (_) { }

  // 添加剪切菜单项
  menu.append(
    new remote.MenuItem({
      label: "剪切",
      accelerator: "CmdOrCtrl+X",
      enabled: can("Cut"),
      click: () => {
        const selectedText = options.selectionText;
        clipboard.writeText(selectedText, "selection");
        webview.executeJavaScript(`document.execCommand('delete')`);
      },
    })
  );

  // 添加粘贴菜单项
  menu.append(
    new remote.MenuItem({
      label: "粘贴",
      accelerator: "CmdOrCtrl+V",
      enabled: options.editFlags[`can${"Paste"}`] && !!clipboard.readText(),
      click: () => {
        webview.executeJavaScript(`
          document.execCommand('paste');
        `);
      },
    })
  );
  return menu;
}

function changeTranslateSrc(e) {
  const source = document.getElementById("translateSrc").value;
  localStorage.setItem("fanyiKey", source);
  setFanyiKey();
  initTransWebview(source);
}

function changeOtherSrc() {
  const source = document.getElementById("otherUrl").value;
  localStorage.setItem("otherKey", source);
  setOtherKey();
  initOtherWebview(source);
}

function closeTranslatemodal() {
  $(".trans-box").hide();
  transSourceWebview = null;
  transWbeview = null;
  $("#transWeb").remove();
  if (fanyiDragInstance) {
    fanyiDragInstance.unset && fanyiDragInstance.unset();
  }
  $("#trans-box").css({
    transform: "none",
  });
}

function closeOthermodal() {
  $(".otherUrl-box").hide();
  otherWebview = null;
  $("#otherWeb").remove();
  if (otherDragInstance) {
    otherDragInstance.unset && otherDragInstance.unset();
  }
  $("#other-box").css({
    transform: "none",
  });
}

function setFanyiKey() {
  fanyiKey = localStorage.getItem("fanyiKey") || "sougou";
}

function setOtherKey() {
  otherKey = localStorage.getItem("otherKey") || "sg_search";
}

function getTransBoxPosition(x, y) {
  const warpWidth = $("#trans-box").width();
  const warpHeight = $("#trans-box").height();
  const maxX = warpWidth + 100;
  const maxH = warpHeight + 200;
  const minX = 140 - $("body").width();
  const minH = 240 - $("body").height();
  if (x > maxX) {
    x = maxX;
  }
  if (x < minX) {
    x = minX;
  }
  if (y > maxH) {
    y = maxH;
  }
  if (y < minH) {
    y = minH;
  }
  return {
    x,
    y,
  };
}

function initFanyiDrag() {
  const target = document.getElementById("trans-box");
  let dragInfo = localStorage.getItem("fanyiDragInfo") || "{}";
  dragInfo = JSON.parse(dragInfo);

  let tx = dragInfo.x || 0;
  let ty = dragInfo.y || 0;
  let tp = getTransBoxPosition(tx, ty);
  tx = tp.x;
  ty = tp.y;
  let scale = 1;

  fanyiDragInstance = new Gesto(target, {
    container: window,
    pinchOutside: true,
    preventDefault: false,
  })
    .on("dragStart", (e) => {
      const isClose = $(e.inputEvent.target).closest(".img-box").length > 0;
      if (!isClose) {
        const ele = $('<div id="drag-fix"></div>');
        ele.appendTo($("body"));
      }
    })
    .on("drag", (e) => {
      const isRight = $("#trans-box").hasClass("trans-box-right");
      if (isRight) return;
      tx += e.deltaX;
      ty += e.deltaY;
      const t_p = getTransBoxPosition(tx, ty);
      tx = t_p.x;
      ty = t_p.y;
      localStorage.setItem("fanyiDragInfo", JSON.stringify({ x: tx, y: ty }));
      target.style.transform = `translate(${tx}px, ${ty}px) scale(${scale})`;
    })
    .on("dragEnd", (e) => {
      $("#drag-fix").remove();
    });

  if (tx || ty) {
    target.style.transform = `translate(${tx}px, ${ty}px) scale(${scale})`;
  }
}

function initOtherDrag() {
  const target = document.getElementById("other-box");
  let dragInfo = localStorage.getItem("otherDragInfo") || "{}";
  dragInfo = JSON.parse(dragInfo);

  let tx = dragInfo.x || 0;
  let ty = dragInfo.y || 0;
  let tp = getTransBoxPosition(tx, ty);
  tx = tp.x;
  ty = tp.y;
  let scale = 1;

  otherDragInstance = new Gesto(target, {
    container: window,
    pinchOutside: true,
    preventDefault: false,
  })
    .on("dragStart", (e) => {
      const isClose = $(e.inputEvent.target).closest(".img-box").length > 0;
      if (!isClose) {
        const ele = $('<div id="otherdrag-fix"></div>');
        ele.appendTo($("body"));
      }
    })
    .on("drag", (e) => {
      const isRight = $("#other-box").hasClass("other-box-right");
      if (isRight) return;
      tx += e.deltaX;
      ty += e.deltaY;
      const t_p = getTransBoxPosition(tx, ty);
      tx = t_p.x;
      ty = t_p.y;
      localStorage.setItem("otherDragInfo", JSON.stringify({ x: tx, y: ty }));
      target.style.transform = `translate(${tx}px, ${ty}px) scale(${scale})`;
    })
    .on("dragEnd", (e) => {
      $("#otherdrag-fix").remove();
    });

  if (tx || ty) {
    target.style.transform = `translate(${tx}px, ${ty}px) scale(${scale})`;
  }
}

function diskSize(num, fixed = 0) {
  if (num == 0) return "0 B";
  var k = 1024; //设定基础容量大小
  // var sizeStr = ['B','KB','MB','GB','TB','PB','EB','ZB','YB']; //容量单位
  var sizeStr = ["B", "K", "M", "G", "T", "P", "E", "Z", "Y"]; //容量单位
  var i = 0; //单位下标和次幂
  for (var l = 0; l < 8; l++) {
    //因为只有8个单位所以循环八次
    if (num / Math.pow(k, l) < 1) {
      //判断传入数值 除以 基础大小的次幂 是否小于1，这里小于1 就代表已经当前下标的单位已经不合适了所以跳出循环
      break; //小于1跳出循环
    }
    i = l; //不小于1的话这个单位就合适或者还要大于这个单位 接着循环
  } // 例： 900 / Math.pow(1024, 0)  1024的0 次幂 是1 所以只要输入的不小于1 这个最小单位就成立了； //     900 / Math.pow(1024, 1)  1024的1次幂 是1024  900/1024 < 1 所以跳出循环 下边的 i = l；就不会执行  所以 i = 0； sizeStr[0] = 'B'; //     以此类推 直到循环结束 或 条件成立
  return (num / Math.pow(k, i)).toFixed(fixed) + sizeStr[i]; //循环结束 或 条件成立 返回字符
}

//自动上传
function autoUpload() {
  let watch = chokidar.watch(downloadDir);
  watch.on("add", addFileListener);
}

function fileExt(name) {
  var fileExtension = name.substring(name.lastIndexOf(".") + 1);
  return fileExtension;
}
function isIncludesArray(str) {
  let fileSuffixList = [
    ".dotx",
    ".doc",
    ".docx",
    ".rtf",
    ".ppt",
    ".pptx",
    ".xls",
    ".xlsx",
    ".csv",
    ".pdf",
    ".PDF",
    ".caj",
    ".txt",
    ".html",
    ".epub",
    ".jpeg",
    ".jpg",
    ".png",
    ".bmp",
    ".zip",
  ];
  if (fileSuffixList.some((it) => str.includes(it))) {
    return true;
  } else {
    return false;
  }
}
const extensionMappings = {
  PDF: "./images/pdf.svg",
  pdf: "./images/pdf.svg",
  caj: "./images/caj.svg",
  epub: "./images/epub.svg",
  amr: "./images/amr.png",
  docx: "./images/doc.svg",
  rtf: "./images/doc.svg",
  dotx: "./images/doc.svg",
  doc: "./images/biji.svg",
  bib: "./images/bibText.svg",
  bjson: "./images/whiteBag.svg",
  xlsx: "./images/excel.svg",
  xls: "./images/excel.svg",
  ppt: "./images/ppt.svg",
  pptx: "./images/ppt.svg",
  mp3: "./images/mp3.svg",
  m4a: "./images/mp3.svg",
  pcm: "./images/mp3.svg",
  wav: "./images/mp3.svg",
  xmind: "./images/xMind.svg",
  html: "./images/html.svg",
  png: "./images/tu.svg",
  bmp: "./images/tu.svg",
  jpg: "./images/tu.svg",
  jpeg: "./images/tu.svg",
  txt: "./images/txt.svg",
  zip: "./images/emma.svg",
  csv: "./images/csv.svg",
};

const defaultIcon = "./images/zhanwei.png";

function setIconByExtension(name, iconDiv) {
  const ext = fileExt(name);
  const iconPath = extensionMappings[ext] || defaultIcon;
  iconDiv.src = iconPath;
}

async function addFileListener(path_) {
  if (!isIncludesArray(path_) || path_.includes("_FIR")) {
    return;
  }
  if (!filePathList.includes(path_)) {
    filePathList.push(path_);
  }
  if (!isProcessing) {
    isProcessing = true;
    await processFiles(); // 处理文件
  }
}
async function processFiles() {
  for (let i = 0; i < filePathList.length; i++) {
    let nameLs = filePathList[i].split("/");
    let name = nameLs[nameLs.length - 1];
    try {
      await uploadFile(filePathList[i], name);
    } catch (err) {
      console.log("err:", err);
    }
  }
  filePathList = []; // 清空文件列表
  isProcessing = false; // 重置处理标志
}
async function uploadFile(filePath, name) {
  return new Promise((resolve, reject) => {
    setTimeout(() => {
      fs.readFile(filePath, async (err, data) => {
        if (err) {
          console.log("err:", err);
          reject(err);
        } else {
          let type = mime.getType(filePath);
          let arrayBuffer = new Int8Array(data);
          let blob = new Blob([arrayBuffer], {
            type: type,
            filename: path.basename(filePath),
          });
          let file = new window.File([blob], name, {
            type: type,
          });
          let winOpen = store.get("windowIsOpen");
          var fileExtension = name.split(".").pop();
          if (file.size / 1024 / 1024 > 200) {
            document.getElementById("requestBu").style.display = "block";
            document.getElementById("requestImg").src = "./images/error.svg";
            document.getElementById("requestImg").style.marginTop = "8px";
            document.getElementById("requestText").innerHTML = "文件超出200MB";
            document.getElementById("requestText").style.marginTop = "75px";
            setTimeout(() => {
              document.getElementById("requestBu").style.display = "none";
            }, 10000);
            resolve();
            return;
          }
          if (isOpen || winOpen) {
            if (
              (isFreeUpload == "1001" || store.get("isFreeUpload") == "1001") &&
              (file.size / 1024 / 1024).toFixed(2) > 20
            ) {
              resolve();
              return copyBox("免费用户单个文件上传不超过20M", 10000, ".etabs-views");
            }
            if (
              (isFreeUpload == "1001" || store.get("isFreeUpload") == "1001") &&
              fileExtension !== "pdf" &&
              fileExtension !== "PDF" &&
              fileExtension !== "epub" &&
              fileExtension !== "caj"
            ) {
              resolve();
              return copyBox("免费用户不支持上传该类型文件", 10000, ".etabs-views");
            }
            let li = document.createElement("li");
            let div = document.createElement("div");
            li.className = "li";
            div.className = "liDiv";
            li.appendChild(div);
            let iconDiv = document.createElement("img");
            iconDiv.className = "iconDiv";
            setIconByExtension(name, iconDiv);
            let spanDiv = document.createElement("div");
            spanDiv.className = "spanDiv";
            div.appendChild(iconDiv);
            div.appendChild(spanDiv);
            let topSpan = document.createElement("span");
            topSpan.className = "topSpan";
            spanDiv.appendChild(topSpan);
            topSpan.innerHTML = path.basename(filePath);
            let bottomSpan = document.createElement("span");
            bottomSpan.className = "bottomSpan";
            spanDiv.appendChild(bottomSpan);
            bottomSpan.innerHTML = (file.size / 1024 / 1024).toFixed(2) + "MB";
            document.getElementById("list").appendChild(li);
            try {
              let chunks = Math.ceil(file.size / chunkSize);
              let fileMd5 = uuidv4();
              if (fileExtension == "pdf" || fileExtension == "PDF") {
                if (file.size > chunkSize) {
                  const formData1 = new FormData();
                  formData1.append("multipart", 1);
                  const resp = await fetch(
                    `${environment}/api/res/upload_token/`,
                    {
                      method: "POST",
                      headers: {
                        "app-Session-Id": globalThis.__token__,
                      },
                      body: formData1,
                    }
                  );
                  const res = await resp.json();
                  if (res.code == 1) {
                    const {
                      file_key,
                      post_header,
                      post_url,
                      put_header,
                      put_url,
                    } = res.data;
                    const etagList = [];
                    for (let i = 0; i < chunks; i++) {
                      let end =
                        (i + 1) * chunkSize >= file.size
                          ? file.size
                          : (i + 1) * chunkSize;
                      const response = await fetch(`${put_url}${i}`, {
                        method: "PUT",
                        headers: put_header,
                        body: file.slice(i * chunkSize, end),
                      });
                      const headers = response.headers;
                      // 遍历响应头
                      headers.forEach((value, name) => {
                        if (name == "etag") {
                          etagList.push(value);
                        }
                      });
                      if (end == file.size && response.status == 200) {
                        const controller = new AbortController();
                        const signal = controller.signal;
                        const timeoutId = setTimeout(() => {
                          controller.abort();
                        }, 60000); // 设置请求超时时间为60秒
                        const result = etagList.map((item) =>
                          item.replace(/\\/g, "")
                        );
                        const output = result.join(",");
                        const formp = new FormData();
                        formp.append("data", output);
                        const rep = await fetch(post_url, {
                          method: "POST",
                          headers: post_header,
                          body: formp,
                        });
                        if (rep.status == 200) {
                          let winSelectedKey = store.get("windowSelectedKey");
                          const repData = new FormData();
                          repData.append("file_key", file_key);
                          repData.append(
                            "file_info",
                            JSON.stringify({
                              name: path.basename(filePath),
                              task_id: fileMd5,
                            })
                          );
                          repData.append(
                            "pid",
                            winSelectedKey == "" || winSelectedKey == undefined
                              ? ""
                              : winSelectedKey || selectkey
                          );
                          try {
                            const Data = await fetch(
                              `${environment}/api/res/upload_success/`,
                              {
                                method: "POST",
                                headers: {
                                  "app-Session-Id": globalThis.__token__,
                                },
                                body: repData,
                                signal,
                              }
                            );
                            const callData = await Data.json();
                            if (callData.code == 1) {
                              clearTimeout(timeoutId);
                              let sucessDiv = document.createElement("div");
                              sucessDiv.className = "sucessDiv";
                              div.appendChild(sucessDiv);
                              let sucessLeft = document.createElement("div");
                              sucessLeft.className = "sucessLeft";
                              sucessLeft.innerHTML = "上传成功";
                              sucessDiv.appendChild(sucessLeft);
                              let sucessOk = document.createElement("img");
                              sucessOk.className = "sucessOk";
                              sucessOk.src = "./images/sucessOk.svg";
                              sucessDiv.appendChild(sucessOk);
                              renameFile(filePath);
                              resolve();
                            } else {
                              document.getElementById(
                                "requestBu"
                              ).style.display = "block";
                              document.getElementById("requestImg").src =
                                "./images/error.svg";
                              document.getElementById(
                                "requestImg"
                              ).style.marginTop = "8px";
                              document.getElementById("requestText").innerHTML =
                                res.msg;
                              document.getElementById(
                                "requestText"
                              ).style.marginTop = "75px";
                              setTimeout(() => {
                                document.getElementById(
                                  "requestBu"
                                ).style.display = "none";
                              }, 10000);
                              let errorDiv = document.createElement("div");
                              errorDiv.className = "errorDiv";
                              div.appendChild(errorDiv);
                              let errorLeft = document.createElement("div");
                              errorLeft.className = "errorLeft";
                              errorLeft.innerHTML = "上传失败";
                              errorDiv.appendChild(errorLeft);
                              let errorOk = document.createElement("img");
                              errorOk.className = "errorOk";
                              errorOk.src = "./images/errorOk.svg";
                              errorDiv.appendChild(errorOk);
                              resolve();
                            }
                          } catch (error) {
                            if (error.name === "AbortError") {
                              document.getElementById(
                                "requestBu"
                              ).style.display = "block";
                              document.getElementById("requestImg").src =
                                "./images/error.svg";
                              document.getElementById(
                                "requestImg"
                              ).style.marginTop = "8px";
                              document.getElementById("requestText").innerHTML =
                                "请求超时";
                              document.getElementById(
                                "requestText"
                              ).style.marginTop = "75px";
                              setTimeout(() => {
                                document.getElementById(
                                  "requestBu"
                                ).style.display = "none";
                              }, 10000);
                              let errorDiv = document.createElement("div");
                              errorDiv.className = "errorDiv";
                              div.appendChild(errorDiv);
                              let errorLeft = document.createElement("div");
                              errorLeft.className = "errorLeft";
                              errorLeft.innerHTML = "请求超时";
                              errorDiv.appendChild(errorLeft);
                              let errorOk = document.createElement("img");
                              errorOk.className = "errorOk";
                              errorOk.src = "./images/errorOk.svg";
                              errorDiv.appendChild(errorOk);
                              renameFile(filePath);
                              resolve();
                            } else {
                              console.error("请求错误", error);
                            }
                          }
                        }
                      }
                    }
                  }
                } else {
                  const formData = new FormData();
                  formData.append("multipart", 0);
                  const response = await fetch(
                    `${environment}/api/res/upload_token/`,
                    {
                      method: "POST",
                      headers: {
                        "app-Session-Id": globalThis.__token__,
                      },
                      body: formData,
                    }
                  );
                  const res = await response.json();
                  if (res.code == 1) {
                    const { file_key, put_header, put_url } = res.data;
                    const resData = await fetch(put_url, {
                      method: "PUT",
                      headers: put_header,
                      body: file,
                    });
                    if (resData.status == 200) {
                      let winSelectedKey = store.get("windowSelectedKey");
                      const postData = new FormData();
                      postData.append("file_key", file_key);
                      postData.append(
                        "file_info",
                        JSON.stringify({
                          name: path.basename(filePath),
                          task_id: uuidv4(),
                        })
                      );
                      postData.append(
                        "pid",
                        winSelectedKey == "" || winSelectedKey == undefined
                          ? ""
                          : winSelectedKey || selectkey
                      );
                      const Data = await fetch(
                        `${environment}/api/res/upload_success/`,
                        {
                          method: "POST",
                          headers: {
                            "app-Session-Id": globalThis.__token__,
                          },
                          body: postData,
                        }
                      );
                      const resp = await Data.json();
                      if (resp.code == 1) {
                        let sucessDiv = document.createElement("div");
                        sucessDiv.className = "sucessDiv";
                        div.appendChild(sucessDiv);
                        let sucessLeft = document.createElement("div");
                        sucessLeft.className = "sucessLeft";
                        sucessLeft.innerHTML = "上传成功";
                        sucessDiv.appendChild(sucessLeft);
                        let sucessOk = document.createElement("img");
                        sucessOk.className = "sucessOk";
                        sucessOk.src = "./images/sucessOk.svg";
                        sucessDiv.appendChild(sucessOk);
                        renameFile(filePath);
                        resolve();
                      } else {
                        document.getElementById("requestBu").style.display =
                          "block";
                        document.getElementById("requestImg").src =
                          "./images/error.svg";
                        document.getElementById("requestImg").style.marginTop =
                          "8px";
                        document.getElementById("requestText").innerHTML =
                          res.msg;
                        document.getElementById("requestText").style.marginTop =
                          "75px";
                        setTimeout(() => {
                          document.getElementById("requestBu").style.display =
                            "none";
                        }, 10000);
                        let errorDiv = document.createElement("div");
                        errorDiv.className = "errorDiv";
                        div.appendChild(errorDiv);
                        let errorLeft = document.createElement("div");
                        errorLeft.className = "errorLeft";
                        errorLeft.innerHTML = "上传失败";
                        errorDiv.appendChild(errorLeft);
                        let errorOk = document.createElement("img");
                        errorOk.className = "errorOk";
                        errorOk.src = "./images/errorOk.svg";
                        errorDiv.appendChild(errorOk);
                        resolve();
                      }
                    }
                  }
                }
              } else {
                if (file.size > chunkSize) {
                  for (let i = 0; i < chunks; i++) {
                    let end =
                      (i + 1) * chunkSize >= file.size
                        ? file.size
                        : (i + 1) * chunkSize;
                    let form = new FormData();
                    form.append("file", file.slice(i * chunkSize, end));
                    form.append("chunk", i);
                    form.append("task_id", fileMd5);
                    const response = await fetch(
                      `${environment}/api/resource/upload/chunk/`,
                      {
                        method: "POST",
                        headers: {
                          "app-Session-Id": globalThis.__token__,
                        },
                        body: form,
                      }
                    );
                    const res = await response.json();
                    if (end == file.size && res.code == 1) {
                      const controller = new AbortController();
                      const signal = controller.signal;
                      const timeoutId = setTimeout(() => {
                        controller.abort();
                      }, 60000); // 设置请求超时时间为60秒
                      let form1 = new FormData();
                      let info = JSON.stringify({
                        name: path.basename(filePath),
                        task_id: fileMd5,
                      });
                      let winSelectedKey = store.get("windowSelectedKey");
                      form1.append("file_info", info);
                      form1.append(
                        "pid",
                        winSelectedKey == "" || winSelectedKey == undefined
                          ? ""
                          : winSelectedKey || selectkey
                      );
                      try {
                        const response1 = await fetch(
                          `${environment}/api/resource/upload/success/`,
                          {
                            method: "POST",
                            headers: {
                              "app-Session-Id": globalThis.__token__,
                            },
                            body: form1,
                            signal,
                          }
                        );
                        const res1 = await response1.json();
                        if (res1.code == 1) {
                          clearTimeout(timeoutId);
                          let sucessDiv = document.createElement("div");
                          sucessDiv.className = "sucessDiv";
                          div.appendChild(sucessDiv);
                          let sucessLeft = document.createElement("div");
                          sucessLeft.className = "sucessLeft";
                          sucessLeft.innerHTML = "上传成功";
                          sucessDiv.appendChild(sucessLeft);
                          let sucessOk = document.createElement("img");
                          sucessOk.className = "sucessOk";
                          sucessOk.src = "./images/sucessOk.svg";
                          sucessDiv.appendChild(sucessOk);
                          renameFile(filePath);
                          resolve();
                        }
                        if (res1.code !== 1) {
                          document.getElementById("requestBu").style.display =
                            "block";
                          document.getElementById("requestImg").src =
                            "./images/error.svg";
                          document.getElementById(
                            "requestImg"
                          ).style.marginTop = "8px";
                          document.getElementById("requestText").innerHTML =
                            res.msg;
                          document.getElementById(
                            "requestText"
                          ).style.marginTop = "75px";
                          setTimeout(() => {
                            document.getElementById("requestBu").style.display =
                              "none";
                          }, 10000);
                          let errorDiv = document.createElement("div");
                          errorDiv.className = "errorDiv";
                          div.appendChild(errorDiv);
                          let errorLeft = document.createElement("div");
                          errorLeft.className = "errorLeft";
                          errorLeft.innerHTML = "上传失败";
                          errorDiv.appendChild(errorLeft);
                          let errorOk = document.createElement("img");
                          errorOk.className = "errorOk";
                          errorOk.src = "./images/errorOk.svg";
                          errorDiv.appendChild(errorOk);
                          resolve();
                        }
                      } catch (error) {
                        if (error.name === "AbortError") {
                          document.getElementById("requestBu").style.display =
                            "block";
                          document.getElementById("requestImg").src =
                            "./images/error.svg";
                          document.getElementById(
                            "requestImg"
                          ).style.marginTop = "8px";
                          document.getElementById("requestText").innerHTML =
                            "请求超时";
                          document.getElementById(
                            "requestText"
                          ).style.marginTop = "75px";
                          setTimeout(() => {
                            document.getElementById("requestBu").style.display =
                              "none";
                          }, 10000);
                          let errorDiv = document.createElement("div");
                          errorDiv.className = "errorDiv";
                          div.appendChild(errorDiv);
                          let errorLeft = document.createElement("div");
                          errorLeft.className = "errorLeft";
                          errorLeft.innerHTML = "请求超时";
                          errorDiv.appendChild(errorLeft);
                          let errorOk = document.createElement("img");
                          errorOk.className = "errorOk";
                          errorOk.src = "./images/errorOk.svg";
                          errorDiv.appendChild(errorOk);
                          renameFile(filePath);
                          resolve();
                        } else {
                          console.error("请求错误", error);
                        }
                      }
                    }
                  }
                } else {
                  const formData2 = new FormData();
                  let winSelectedKey = store.get("windowSelectedKey");
                  formData2.append("file", file);
                  formData2.append(
                    "file_info",
                    JSON.stringify({
                      name: path.basename(filePath),
                      task_id: uuidv4(),
                    })
                  );
                  formData2.append(
                    "pid",
                    winSelectedKey == "" || winSelectedKey == undefined
                      ? ""
                      : winSelectedKey || selectkey
                  );
                  const response = await fetch(
                    `${environment}/api/resource/upload/whole/`,
                    {
                      method: "POST",
                      headers: {
                        "app-Session-Id": globalThis.__token__,
                      },
                      body: formData2,
                    }
                  );
                  const res = await response.json();
                  if (res.code == 1) {
                    let sucessDiv = document.createElement("div");
                    sucessDiv.className = "sucessDiv";
                    div.appendChild(sucessDiv);
                    let sucessLeft = document.createElement("div");
                    sucessLeft.className = "sucessLeft";
                    sucessLeft.innerHTML = "上传成功";
                    sucessDiv.appendChild(sucessLeft);
                    let sucessOk = document.createElement("img");
                    sucessOk.className = "sucessOk";
                    sucessOk.src = "./images/sucessOk.svg";
                    sucessDiv.appendChild(sucessOk);
                    renameFile(filePath);
                    resolve();
                  }
                  if (res.code !== 1) {
                    document.getElementById("requestBu").style.display =
                      "block";
                    document.getElementById("requestImg").src =
                      "./images/error.svg";
                    document.getElementById("requestImg").style.marginTop =
                      "8px";
                    document.getElementById("requestText").innerHTML = res.msg;
                    document.getElementById("requestText").style.marginTop =
                      "75px";
                    document.getElementById("requestText").style.lineHeight = res.msg.length > 20 ? 'initial' : 'inherit'
                    setTimeout(() => {
                      document.getElementById("requestBu").style.display =
                        "none";
                    }, 10000);
                    let errorDiv = document.createElement("div");
                    errorDiv.className = "errorDiv";
                    div.appendChild(errorDiv);
                    let errorLeft = document.createElement("div");
                    errorLeft.className = "errorLeft";
                    errorLeft.innerHTML = "上传失败";
                    errorDiv.appendChild(errorLeft);
                    let errorOk = document.createElement("img");
                    errorOk.className = "errorOk";
                    errorOk.src = "./images/errorOk.svg";
                    errorDiv.appendChild(errorOk);
                    resolve();
                  }
                }
              }
            } catch (err) {
              reject(err);
            }
          }
        }
      });
    }, 1000);
  });
}

// 重命名文件,下次上传忽略该文件
function renameFile(path) {
  let prefixName = path.substring(0, path.lastIndexOf("."));
  let suffix = fileExt(path);
  let newPath = prefixName + "_FIR." + suffix;
  fs.renameSync(path, newPath);
}
// 删除文件
function removeFile(path) {
  fs.rm(path, (err) => {
    if (err) {
      console.log(err);
    }
  });
}

function createDir(cb) {
  dialog
    .showMessageBox({
      type: "none",
      icon: "none",
      title: "选择默认下载文件夹",
      message: "请选择FIR Library目录同步位置。",
      buttons: ["确认"],
      cancel: false,
    })
    .then((res) => {
      dialog
        .showOpenDialog({
          title: "选择默认下载文件夹",
          properties: ["openDirectory", "createDirectory"], // 选择目录openDirectory
        })
        .then(({ canceled, filePaths }) => {
          if (canceled) {
            dialog.showMessageBox({
              type: "none",
              icon: "none",
              title: "温馨提示",
              message:
                "由于您没有选择相应文件目录,如需要使用下载文件自动上传功能,请重启应用后选择对应下载目录",
              buttons: ["确认"],
            });
          } else {
            cb(filePaths);
          }
        });
    });
}

function createFileHash256(filePath) {
  return new Promise((resolve, reject) => {
    const stream = fs.createReadStream(filePath);
    const fsHash = crypto.createHash("sha256");

    stream.on("data", function (d) {
      fsHash.update(d);
    });

    stream.on("end", function () {
      const md5 = fsHash.digest("hex");
      resolve(md5);
    });
  });
}
//创建hash值
function createFileHash256Sync(filePath) {
  //读取一个Buffer
  const buffer = fs.readFileSync(filePath);
  const fsHash = crypto.createHash("sha256");
  fsHash.update(buffer);
  const md5 = fsHash.digest("hex");
  return md5;
}

//读取文件hash值
function getFileHash(path) {

  return new Promise((resolve, reject) =>
    fs
      .createReadStream(path)
      .on("error", reject)
      .pipe(crypto.createHash("sha256").setEncoding("hex"))
      .once("finish", function () {
        resolve(this.read());
      })
  );
}
