// Modules to control application life and create native browser window
const {
  app,
  BrowserWindow,
  ipcMain,
  shell,
  Tray,
  Menu,
  dialog,
    session,
} = require("electron");
const path = require("path");
const { autoUpdater } = require("electron-updater");

const ElectronStore = require("electron-store");

const tranlateSpider = require("./js/fanyi/spider");
const { createEvents, setWindow } = require("./js/server/event");

const ALLOWED_HOSTS = new Set([
   'cdn.qinyanai.com'
    // ... 你的白名单
]);

function isAllowedUrl(rawUrl) {
    try {
        const u = new URL(rawUrl);
        // 只放行 HTTPS 与白名单域名
        if (u.protocol !== 'https:') return false;
        return ALLOWED_HOSTS.has(u.hostname);
    } catch (_) {
        return false;
    }
}


ElectronStore.initRenderer();

let mainWindow, webContents;

let translateConnect = false;

let template = [
  {
    label: "编辑",
    submenu: [
      {
        label: "撤销",
        accelerator: "CmdOrCtrl+Z",
        role: "undo",
      },
      {
        label: "重做",
        accelerator: "Shift+CmdOrCtrl+Z",
        role: "redo",
      },
      {
        type: "separator",
      },
      {
        label: "剪切",
        accelerator: "CmdOrCtrl+X",
        role: "cut",
      },
      {
        label: "复制",
        accelerator: "CmdOrCtrl+C",
        role: "copy",
      },
      {
        label: "粘贴",
        accelerator: "CmdOrCtrl+V",
        role: "paste",
      },
      {
        label: "全选",
        accelerator: "CmdOrCtrl+A",
        role: "selectall",
      },
    ],
  },
  {
    label: "查看",
    submenu: [
      {
        label: "重载",
        accelerator: "CmdOrCtrl+R",
        click: (item, focusedWindow) => {
          if (focusedWindow) {
            // 重载之后, 刷新并关闭所有之前打开的次要窗体
            if (focusedWindow.id === 1) {
              BrowserWindow.getAllWindows().forEach((win) => {
                if (win.id > 1) win.close();
              });
            }
            focusedWindow.reload();
          }
        },
      },
      {
        label: "切换全屏",
        accelerator: (() => {
          if (process.platform === "darwin") {
            return "Ctrl+Command+F";
          } else {
            return "F11";
          }
        })(),
        click: (item, focusedWindow) => {
          if (focusedWindow) {
            focusedWindow.setFullScreen(!focusedWindow.isFullScreen());
          }
        },
      },
      {
        label: "切换开发者工具",
        accelerator: (() => {
          if (process.platform === "darwin") {
            return "Alt+Command+I";
          } else {
            return "Ctrl+Shift+I";
          }
        })(),
        click: (item, focusedWindow) => {
          if (focusedWindow) {
            focusedWindow.toggleDevTools();
          }
        },
      },
      {
        type: "separator",
      },
      {
        label: "翻译选中文本",
        accelerator: "CmdOrCtrl+Shift+T",
        click: () => {
          try {
            if (mainWindow && !mainWindow.isDestroyed()) {
              mainWindow.webContents.send("hotkey-translate-selection");
            }
          } catch (e) {
            console.error("send hotkey failed", e);
          }
        },
      },
    ],
  },
  // {
  //   label: "窗口",
  //   role: "window",
  //   submenu: [
  //     {
  //       label: "最小化",
  //       accelerator: "CmdOrCtrl+M",
  //       role: "minimize",
  //     },
  //     {
  //       label: "关闭",
  //       accelerator: "CmdOrCtrl+W",
  //       role: "close",
  //     },
  //     {
  //       type: "separator",
  //     },
  //     {
  //       label: "重新打开窗口",
  //       accelerator: "CmdOrCtrl+Shift+T",
  //       enabled: false,
  //       key: "reopenMenuItem",
  //       click: () => {
  //         app.emit("activate");
  //       },
  //     },
  //   ],
  // },
  // {
  //   label: "帮助",
  //   role: "help",
  //   submenu: [
  //     {
  //       label: "学习更多",
  //       click: () => {
  //         shell.openExternal("http://electron.atom.io");
  //       },
  //     },
  //   ],
  // },
];

function findReopenMenuItem() {
  const menu = Menu.getApplicationMenu();
  if (!menu) return;

  let reopenMenuItem;
  menu.items.forEach((item) => {
    if (item.submenu) {
      item.submenu.items.forEach((item) => {
        if (item.key === "reopenMenuItem") {
          reopenMenuItem = item;
        }
      });
    }
  });
  return reopenMenuItem;
}

if (process.platform === "darwin") {
  const name = app.getName();
  template.unshift({
    label: name,
    submenu: [
      {
        label: `关于 ${name}`,
        role: "about",
      },
      {
        type: "separator",
      },
      {
        label: "服务",
        role: "services",
        submenu: [],
      },
      {
        type: "separator",
      },
      {
        label: `隐藏 ${name}`,
        accelerator: "Command+H",
        role: "hide",
      },
      {
        label: "隐藏其它",
        accelerator: "Command+Alt+H",
        role: "hideothers",
      },
      {
        label: "显示全部",
        role: "unhide",
      },
      {
        type: "separator",
      },
      {
        label: "退出",
        accelerator: "Command+Q",
        click: () => {
          app.quit();
        },
      },
    ],
  });

  // 窗口菜单.
  // template[3].submenu.push(
  //   {
  //     type: "separator",
  //   },
  //   {
  //     label: "前置所有",
  //     role: "front",
  //   }
  // );

  // addUpdateMenuItems(template[0].submenu, 1);
}

if (process.platform === "win32") {
  const helpMenu = template[template.length - 1].submenu;
  // addUpdateMenuItems(helpMenu, 0);
}

function createWindow() {
  // Create the browser window.
  try {
    mainWindow = new BrowserWindow({
      // width: 800,
      // height: 600,
      show: false,
      webPreferences: {
        preload: path.join(__dirname, "js/preload.js"),
        nodeIntegration: true,
        contextIsolation: false,
        // nodeIntegration: true,
        webviewTag: true,
        enableRemoteModule: true,
      },
    });
    mainWindow.maximize();
    webContents = mainWindow.webContents;
    // webContents.openDevTools();
    mainWindow.loadURL("file://" + __dirname + "/index.html");
    mainWindow.on("ready-to-show", function () {
      if (mainWindow.isDestroyed()) return;

      mainWindow.show();
      mainWindow.focus();
    });
    setWindow(mainWindow.id, true);
  } catch (error) {
    console.error("main createWindow");
    console.error(error);
  }
}
// This method will be called when Electron has finished
// initialization and is ready to create browser windows.
// Some APIs can only be used after this event occurs.
app.on("ready", () => {
  const appMenu = Menu.buildFromTemplate(template);
  Menu.setApplicationMenu(appMenu);
  // ipcMain.on("show-context-menu", (event) => {
  //   const webContents = event.sender;
  //   const template = [
  //     {
  //       label: "复制",
  //       accelerator: "CmdOrCtrl+C",
  //       click: () => {
  //         webContents.copy();
  //       },
  //       role: "copy",
  //     },
  //     {
  //       label: "剪切",
  //       accelerator: "CmdOrCtrl+X",
  //       click: () => {
  //         webContents.cut();
  //       },
  //     },
  //     {
  //       label: "粘贴",
  //       accelerator: "CmdOrCtrl+V",
  //       click: () => {
  //         webContents.paste();
  //       },
  //     },
  //   ];
  //   const menu = Menu.buildFromTemplate(template);
  //   menu.popup({ window: BrowserWindow.fromWebContents(webContents) });
  // });
});

app.whenReady().then(() => {
    const partName = 'persist:trusted'; // 与 webview 的 partition 对应
    const s = session.fromPartition(partName);

    // 1) 拦截所有资源请求：仅放行白名单
    s.webRequest.onBeforeRequest((details, callback) => {
        // 主文档导航也会经过这里（resourceType = 'mainFrame'）
        if (isAllowedUrl(details.url)) {
            return callback({ cancel: false });
        }
        return callback({ cancel: true });
    });


    ipcMain.handle("clientTranslateSpider", tranlateSpider);
  createWindow();

  app.on("activate", function () {
    // On macOS it's common to re-create a window in the app when the
    // dock icon is clicked and there are no other windows open.
    if (BrowserWindow.getAllWindows().length === 0) createWindow();
  });

  ipcMain.on("changeConnect", (e, checked) => {
    translateConnect = checked;
  });

  ipcMain.handle("getTranslateConnect", () => {
    return translateConnect;
  });

  ipcMain.handle("getOtherConnect", () => {
    return true;
  });

  const store = new ElectronStore();
  createEvents({ store, mainWindow });
});

// Quit when all windows are closed, except on macOS. There, it's common
// for applications and their menu bar to stay active until the user quits
// explicitly with Cmd + Q.
app.on("window-all-closed", function () {
  globalThis.wss && globalThis.wss.close();
  if (process.platform !== "darwin") app.quit();
  let reopenMenuItem = findReopenMenuItem();
  if (reopenMenuItem) reopenMenuItem.enabled = true;
});

// app.dock.hide()
// In this file you can include the rest of your app's specific main process
// code. You can also put them in separate files and require them here.

app.on("web-contents-created", (e, webContents) => {
  webContents.setWindowOpenHandler((details, e) => {

    let { url } = details;
    if (
      url.indexOf("kns8/Detail") > -1 &&
      url.indexOf("RedirectScholar") == -1 &&
      url.indexOf("sfield") == -1 &&
      url.indexOf("Read") == -1
    ) {
      var arg = new URL(url);
      const DbCode =
        arg.searchParams.get("DbCode") || arg.searchParams.get("dbCode");
      const DbName =
        arg.searchParams.get("DbName") || arg.searchParams.get("dbname");
      const FileName =
        arg.searchParams.get("FileName") || arg.searchParams.get("filename");
      url = `https://kns.cnki.net/kcms/detail/detail.aspx?dbcode=${DbCode}&dbname=${DbName}&filename=${FileName}`;
    }

    if (url.indexOf("ieeexplore.ieee.org/stamp") > -1 || url.indexOf('https://pubmed.ncbi.nlm.nih.gov/') > -1 || url.indexOf('https://www.sciencedirect.com/') > -1 || url.indexOf('https://www.researchgate.net/') > -1) {
      // var parser = new URL(url);
      // // 获取arnumber的值
      // var arnumber = parser.searchParams.get("arnumber");
      //   url = `https://ieeexplore.ieee.org/document/${arnumber}`;
      shell.openExternal(url);
      return
    }

    mainWindow.webContents.send("tab-added", {
      title: url,
      src: url,
      visible: true,
      active: true,
    });

    return { action: "deny" };
  });
  // webContents.on("new-window", (event, url, frameName, disposition) => {
  //   // webContents.on("browser-window-created", (event, url, frameName, disposition) => {
  //     console.log(webContents)
  //     if (url.indexOf("kns8/Detail") > -1) {
  //       var arg = new URL(url);
  //       const DbCode =
  //         arg.searchParams.get("DbCode") || arg.searchParams.get("dbCode");
  //       const DbName =
  //         arg.searchParams.get("DbName") || arg.searchParams.get("dbname");
  //       const FileName =
  //         arg.searchParams.get("FileName") || arg.searchParams.get("filename");
  //       url = `https://kns.cnki.net/kcms/detail/detail.aspx?dbcode=${DbCode}&dbname=${DbName}&filename=${FileName}`;
  //     }
  //     mainWindow.webContents.send("tab-added", {
  //       title: url,
  //       src: url,
  //       visible: true,
  //       active: true,
  //     });
  //   });

  webContents.on(
    "did-start-navigation",
    (event, url, frameName, disposition) => {
      mainWindow.webContents.send("can-goback", webContents.canGoBack());
      mainWindow.webContents.send("can-goforward", webContents.canGoForward());
    }
  );
  let reopenMenuItem = findReopenMenuItem();
  if (reopenMenuItem) reopenMenuItem.enabled = false;
});

// const feedUrl = `https://testfirencrypt.cn-sh2.ufileos.com/testfile/cyprex/`; // 测试更新包位置
const feedUrl =
  "http://fir-statics.cn-sh2.ufileos.com/pd/files/installs/AutoUpdate/";
autoUpdater.setFeedURL(feedUrl);
let message = {
  error: "检查更新出错",
  checking: "正在检查更新……",
  updateAva: "检测到新版本，正在下载",
  updateNotAva: "现在使用的就是最新版本，不用更新",
};
autoUpdater.on("error", function (error) {
  sendUpdateMessage(message.error);
});
autoUpdater.on("checking-for-update", function () {
  sendUpdateMessage(message.checking);
});
autoUpdater.on("update-available", function (info) {
  sendUpdateMessage(message.updateAva);
});
autoUpdater.on("update-not-available", function (info) {
  sendUpdateMessage(message.updateNotAva);
});

// 更新下载进度事件
autoUpdater.on("download-progress", function (progressObj) {
  //与渲染进程通信
  mainWindow.webContents.send("downloadProgress", progressObj);
  mainWindow.setProgressBar(progressObj.percent / 100);
});
autoUpdater.autoDownload = false;
autoUpdater.on(
  "update-downloaded",
  function (
    event,
    releaseNotes,
    releaseName,
    releaseDate,
    updateUrl,
    quitAndUpdate
  ) {
    ipcMain.on("isUpdateNow", (e, arg) => {
      autoUpdater.quitAndInstall();
    });

    mainWindow.webContents.send("isUpdateNow");
  }
);
ipcMain.on("checkForUpdate", () => {
  //放外面的话启动客户端执行自动更新检查
  autoUpdater.checkForUpdates();
});
ipcMain.on("manualUpdate", () => {
  autoUpdater.downloadUpdate();
});
function sendUpdateMessage(text) {
  mainWindow.webContents.send("message", text);
}
